function [loglik,tempx,tempy]=LogLikP(pars,data,problems,rsr)
% This is going to be the log-likelihood function for case 2
rp=pars(1);
dp=pars(2);
tp=pars(3);
np=size(problems,1);
on=ones(np,1);
for pn=1:1:np
        temp=1/(1+exp(-dp*(rsr(pn)-rp)));                     % without a tremble
        tempx(pn,1)=(1-2*tp)*temp+tp;                         % with a tremble A&B
        tempy(pn,1)=1-tempx(pn,1);                            % ditto
        if ((pn==10) || (pn==20) || (pn==30) || (pn==40))
            tempx(pn,1)=(1-tp);
            tempy(pn,1)=tp;
        end
end
loglik=data(:,1).*log(tempx)+data(:,2).*log(tempy);
loglik=-on'*loglik;
end

